<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Http\Request;

class SalesReportExport implements FromCollection, WithHeadings
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = DB::table('bookings')
            ->leftJoin('users', 'bookings.user_id', '=', 'users.id')
            ->leftJoin('rooms', 'bookings.room_id', '=', 'rooms.id')
            ->select(
                'bookings.booking_number',
                'users.name as guest_name',
                'bookings.checkin_date',
                'bookings.checkout_date',
                'bookings.total_amount',
                'bookings.total_paid',
                DB::raw('(bookings.total_amount - bookings.total_paid) as due'),
                'bookings.status',
                'rooms.room_type',
                'rooms.room_no',
                'bookings.created_at'
            );

        if ($this->request->filled('date_from')) {
            $query->whereDate('bookings.created_at', '>=', $this->request->date_from);
        }
        if ($this->request->filled('date_to')) {
            $query->whereDate('bookings.created_at', '<=', $this->request->date_to);
        }

        return $query->get();
    }

    public function headings(): array
    {
        return [
            'Booking Number',
            'Guest',
            'Check In',
            'Check Out',
            'Total Amount',
            'Total Paid',
            'Due',
            'Status',
            'Room Type',
            'Room No',
            'Date',
        ];
    }
}
