<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Report - A4 Print</title>
    <link rel="stylesheet" href="{{ asset('assets/admin/css/bootstrap.min.css') }}">
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 14px;
            color: #000;
            background: #fff;
            margin: 20px;
        }
        .report-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .report-header h4 {
            margin: 0;
            font-weight: 600;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px 10px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .totals {
            margin-top: 20px;
            text-align: right;
        }
        .totals td {
            font-weight: bold;
        }
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="report-header">
        <h4>Sales Report</h4>
        <p>{{ date('F d, Y') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Booking No.</th>
                <th>Guest</th>
                <th>Check In</th>
                <th>Check Out</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Due</th>
                <th>Status</th>
                <th>Room Type</th>
                <th>Room No</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($bookings as $b)
                <tr>
                    <td>{{ $b->booking_number }}</td>
                    <td>{{ $b->guest_name }}</td>
                    <td>{{ $b->checkin_date }}</td>
                    <td>{{ $b->checkout_date }}</td>
                    <td>{{ number_format($b->total_amount, 2) }}</td>
                    <td>{{ number_format($b->total_paid, 2) }}</td>
                    <td>{{ number_format($b->due, 2) }}</td>
                    <td>{{ ucfirst($b->status) }}</td>
                    <td>{{ $b->room_type }}</td>
                    <td>{{ $b->room_no }}</td>
                    <td>{{ $b->created_at }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <table class="totals" align="right">
        <tr><td>Total Amount:</td><td>{{ number_format($totals['amount'], 2) }}</td></tr>
        <tr><td>Total Paid:</td><td>{{ number_format($totals['paid'], 2) }}</td></tr>
        <tr><td>Total Due:</td><td>{{ number_format($totals['due'], 2) }}</td></tr>
    </table>

    <div class="no-print text-center mt-3">
        <button onclick="window.print()" class="btn btn-primary btn-sm">Print</button>
        <a href="{{ route('admin.sales.report') }}" class="btn btn-secondary btn-sm">Back</a>
    </div>
</body>
</html>
