<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Report - Thermal Print</title>
    <style>
        @media print {
            @page { size: 80mm auto; margin: 0; }
            body { margin: 0; }
        }
        body {
            font-family: monospace;
            font-size: 12px;
            color: #000;
            width: 80mm;
            margin: 0 auto;
        }
        .center {
            text-align: center;
        }
        .divider {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        td {
            padding: 2px 0;
            vertical-align: top;
        }
        .bold {
            font-weight: bold;
        }
        .totals {
            margin-top: 10px;
            text-align: right;
        }
        .no-print {
            text-align: center;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="center">
        <h4>Sales Report</h4>
        <p>{{ date('F d, Y') }}</p>
    </div>

    <div class="divider"></div>

    <table>
        <thead>
            <tr>
                <td class="bold">Booking</td>
                <td class="bold">Guest</td>
                <td class="bold right">Amount</td>
            </tr>
        </thead>
        <tbody>
            @foreach ($bookings as $b)
                <tr>
                    <td>{{ $b->booking_number }}</td>
                    <td>{{ $b->guest_name }}</td>
                    <td>{{ number_format($b->total_amount, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="divider"></div>

    <table class="totals" align="right">
        <tr><td>Total: ₦{{ number_format($totals['amount'], 2) }}</td></tr>
        <tr><td>Paid: ₦{{ number_format($totals['paid'], 2) }}</td></tr>
        <tr><td>Due: ₦{{ number_format($totals['due'], 2) }}</td></tr>
    </table>

    <div class="no-print">
        <button onclick="window.print()">Print</button>
        <a href="{{ route('admin.sales.report') }}">Back</a>
    </div>
</body>
</html>
