@extends('admin.layouts.app')

@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10">
            <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
                <form action="{{ route('admin.sales.report') }}" method="GET" class="d-flex flex-wrap gap-2">
                    <div>
                        <label class="form-label mb-1">@lang('Date From')</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control form-control-sm">
                    </div>
                    <div>
                        <label class="form-label mb-1">@lang('Date To')</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control form-control-sm">
                    </div>
                    <div class="align-self-end">
                        <button type="submit" class="btn btn--primary btn-sm"><i class="la la-filter"></i> @lang('Filter')</button>
                    </div>
                </form>

                <div class="d-flex flex-wrap gap-2 align-items-center">
                    <a href="{{ route('admin.sales.report.excel', request()->all()) }}" class="btn btn-success btn-sm">
                        <i class="la la-file-excel"></i> @lang('Export Excel')
                    </a>
                    <a href="{{ route('admin.sales.report.csv', request()->all()) }}" class="btn btn-warning btn-sm text-white">
                        <i class="la la-file-alt"></i> @lang('Export CSV')
                    </a>
                    <a href="{{ route('admin.sales.report') }}?{{ http_build_query(array_merge(request()->all(), ['print' => 'a4'])) }}" target="_blank" class="btn btn-info btn-sm">
                        <i class="la la-print"></i> @lang('Print A4')
                    </a>
                    <a href="{{ route('admin.sales.report') }}?{{ http_build_query(array_merge(request()->all(), ['print' => 'thermal'])) }}" target="_blank" class="btn btn-dark btn-sm">
                        <i class="la la-receipt"></i> @lang('Print 80mm')
                    </a>
                </div>
            </div>
            
            


            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table--light style--two table">
                        <thead>
                            <tr>
                                <th>@lang('Booking No.')</th>
                                <th>@lang('Guest')</th>
                                <th>@lang('Room Type')</th>
                                <th>@lang('Room No')</th>
                                <th>@lang('Check In')</th>
                                <th>@lang('Check Out')</th>
                                <th>@lang('Total')</th>
                                <th>@lang('Paid')</th>
                                <th>@lang('Due')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Date')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($bookings as $b)
                                <tr>
                                    <td>{{ $b->booking_number }}</td>
                                    <td>{{ $b->guest_name ?? 'N/A' }}</td>
                                    <td>{{ $b->room_type ?? 'N/A' }}</td>
                                    <td>{{ $b->room_no ?? 'N/A' }}</td>
                                    <td>{{ showDateTime($b->checkin_date) }}</td>
                                    <td>{{ showDateTime($b->checkout_date) }}</td>
                                    <td>{{ showAmount($b->total_amount) }}</td>
                                    <td>{{ showAmount($b->total_paid) }}</td>
                                    <td>{{ showAmount($b->due) }}</td>
                                    <td>
                                        <span class="badge 
                                            @if($b->status == 'confirmed') badge--success
                                            @elseif($b->status == 'pending') badge--warning
                                            @else badge--danger
                                            @endif">
                                            {{ ucfirst($b->status) }}
                                        </span>
                                    </td>
                                    <td>{{ showDateTime($b->created_at) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="11" class="text-center text-muted">@lang('No sales found for selected range')</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer text-end">
                <div class="fw-bold">
                    <span>@lang('Total Amount'):</span> {{ showAmount($totals['amount']) }} |
                    <span>@lang('Total Paid'):</span> {{ showAmount($totals['paid']) }} |
                    <span>@lang('Total Due'):</span> {{ showAmount($totals['due']) }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
