<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $general->siteName('Thermal Invoice') }}</title>
    <style>
        * { margin: 1px 0px 0px 0px; padding: 0; box-sizing: border-box; font-family: 'Courier New', monospace; }
        body {
            font-size: 12px;
            width: 93%;
            padding: 8px 10px; /* adds top/bottom + left/right margin */
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .divider { border-top: 1px dashed #000; margin: 10px 0; }
        .section { margin-bottom: 15px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { text-align: left; padding: 2px 0; }
        th { border-bottom: 1px solid #000; font-weight: bold; }
        .right { text-align: right; }
        .total-line td { border-top: 1px dashed #000; font-weight: bold; }
        .footer { text-align: center; margin-top: 12px; font-size: 11px; }
    </style>
</head>

<body>
    @php
        $guest = is_string($booking->guest_details)
            ? json_decode($booking->guest_details)
            : $booking->guest_details;
        $extraService = count($booking->usedExtraService);
        $due = $booking->total_amount - $booking->paid_amount;
    @endphp

    <div class="center">
        <h3>{{ $general->sitename }}</h3>
        <p>{{ $general->address ?? '' }}</p>
        <p><small>{{ date('d M, Y h:i A') }}</small></p>
    </div>

    <div class="divider"></div>

    <div class="section">
        <p><span class="bold">Booking No:</span> {{ $booking->booking_number }}</p>
        <p><span class="bold">Guest:</span> {{ optional($booking->user)->firstname ?? ($guest->name ?? 'N/A') }}</p>
        <p><span class="bold">Email:</span> {{ optional($booking->user)->email ?? ($guest->email ?? 'N/A') }}</p>
        <p><span class="bold">Phone:</span> {{ optional($booking->user)->mobile ?? ($guest->mobile ?? 'N/A') }}</p>
        <p><span class="bold">Check In:</span> {{ showDateTime($booking->check_in, 'd M, Y') }}</p>
        <p><span class="bold">Check Out:</span> {{ showDateTime($booking->check_out, 'd M, Y') }}</p>
    </div>

    <div class="divider"></div>

    @php
        $activeBookedRooms = $booking->activeBookedRooms->groupBy('booked_for');
        $totalFare = $booking->activeBookedRooms->sum('fare');
    @endphp

    <div class="section">
        <h4 class="center">Room Details</h4>
        <table>
            <thead>
                <tr>
                    <th>Room</th>
                    <th>Type</th>
                    <th class="right">Fare</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($activeBookedRooms as $key => $rooms)
                    <tr><td colspan="3" class="center"><small>{{ showDateTime($key, 'd M, Y') }}</small></td></tr>
                    @foreach ($rooms as $room)
                        <tr>
                            <td>{{ $room->room->room_number }}</td>
                            <td>{{ $room->room->roomType->name }}</td>
                            <td class="right">{{ showAmount($room->fare) }}</td>
                        </tr>
                    @endforeach
                @endforeach
                <tr class="total-line">
                    <td colspan="2">Total Fare</td>
                    <td class="right">{{ showAmount($totalFare) }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    @if ($extraService)
        <div class="divider"></div>
        <div class="section">
            <h4 class="center">Extra Services</h4>
            @php $extraGroups = $booking->usedExtraService->groupBy('service_date'); @endphp
            <table>
                <thead>
                    <tr>
                        <th>Room</th>
                        <th>Service</th>
                        <th class="right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($extraGroups as $date => $services)
                        <tr><td colspan="3" class="center"><small>{{ showDateTime($date, 'd M, Y') }}</small></td></tr>
                        @foreach ($services as $srv)
                            <tr>
                                <td>{{ $srv->room->room_number }}</td>
                                <td>{{ $srv->extraService->name }}</td>
                                <td class="right">{{ showAmount($srv->total_amount) }}</td>
                            </tr>
                        @endforeach
                    @endforeach
                    <tr class="total-line">
                        <td colspan="2">Service Total</td>
                        <td class="right">{{ showAmount($booking->service_cost) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    @endif

    <div class="divider"></div>

    <div class="section">
        <h4 class="center">Billing Summary</h4>
        <table>
            <tbody>
                @if ($booking->cancellation_fee > 0)
                    <tr><td>Cancellation Fee</td><td class="right">{{ showAmount($booking->cancellation_fee) }}</td></tr>
                @endif
                <tr><td>{{ __($general->tax_name) }}</td><td class="right">{{ showAmount($booking->tax_charge) }}</td></tr>
                @if ($booking->extraCharge() > 0)
                    <tr><td>Other Charges</td><td class="right">{{ showAmount($booking->extraCharge()) }}</td></tr>
                @endif
                <tr><td>Total</td><td class="right">{{ showAmount($booking->total_amount) }}</td></tr>
                <tr><td>Paid</td><td class="right">{{ showAmount($booking->paid_amount) }}</td></tr>
                @if ($due > 0)
                    <tr><td>Due</td><td class="right">{{ showAmount($due) }}</td></tr>
                @elseif ($due < 0)
                    <tr><td>Refundable</td><td class="right">{{ showAmount(abs($due)) }}</td></tr>
                @endif
            </tbody>
        </table>
    </div>

    <div class="divider"></div>

    <div class="footer">
        <p>Thank you for choosing us.</p>
        <p><small>Printed on {{ now()->format('d M, Y h:i A') }}</small></p>
    </div>
    
    
    <div class="footer">
        <p></br></p>
    </div>
    
</body>
</html>
