<?php
$testimonialContent = getContent('testimonial.content', true);
$testimonialElement = getContent('testimonial.element', false);
?>

<section class="section dark--overlay bg_img overflow-hidden" style="background-image: url('<?php echo e(getImage('assets/images/frontend/testimonial/' . $testimonialContent->data_values->background_image, '1800x900')); ?>');">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7 text-center">
                <div class="section-header">
                    <h2 class="section-title text-white"><?php echo e(__($testimonialContent->data_values->heading)); ?></h2>
                    <p class="text-white"><?php echo e(__($testimonialContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="testimonial-slider">
            <?php $__currentLoopData = $testimonialElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="single-slide">
                    <div class="testimonial-card">
                        <div class="testimonial-card__thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/testimonial/' . $item->data_values->image, '150x150')); ?>" alt="image">
                        </div>
                        <h6><?php echo e(__($item->data_values->name)); ?></h6>
                        <p class="fs--14px"><?php echo e(__($item->data_values->designation)); ?></p>
                        <i class="fas fa-quote-left"></i>
                        <p class="testimonial-card__description"><?php echo e(__($item->data_values->feedback)); ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/sections/testimonial.blade.php ENDPATH**/ ?>