<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta content="IE=edge" http-equiv="X-UA-Compatible" />
    <meta content="IE=edge" http-equiv="X-UA-Compatible" />
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title><?php echo e($general->siteName('Invoice')); ?></title>
    <link href="<?php echo e(getImage(getFilePath('logoIcon') . '/favicon.png')); ?>" rel="shortcut icon" type="image/png">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/invoice.css')); ?>">
</head>

<body>
    <?php
        $extraService = count($booking->usedExtraService);
        $due = $booking->total_amount - $booking->paid_amount;
    ?>
    <header>
        <div class="row">
            <div class="col-12">
                <div class="list--row">
                    <div class="logo float-left">
                        <img alt="<?php echo app('translator')->get('image'); ?>" class="logo-img" src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>">
                    </div>
                    <h6 class="float-right m-0" style="margin: 0;"> <?php echo e(date('d/m/Y')); ?></h6>
                </div>
            </div>
        </div>
    </header>
    <main>
        <div class="row">
            <div class="col-12">
                <div class="address list--row">
                    <div class="float-left">
                        <h5 class="primary-text d-block fw-md"><?php echo app('translator')->get('Invoice To'); ?></h5>
                        <ul class="list" style="--gap: 0.3rem">
                            <li>
                                <div class="list list--row gap-5rem">
                                    <span class="strong"><?php echo app('translator')->get('Name'); ?> :</span>
                                    <span><?php echo e($booking->user ? $booking->user->fullname : $booking->guest_details->name); ?></span>
                                </div>
                            </li>
                            <li>
                                <div class="list list--row gap-5rem">
                                    <span class="strong"><?php echo app('translator')->get('Email'); ?> :</span>
                                    <span><?php echo e($booking->user ? $booking->user->email : $booking->guest_details->email); ?></span>
                                </div>
                            </li>
                            <li>
                                <div class="list list--row gap-5rem">
                                    <span class="strong"><?php echo app('translator')->get('Mobile'); ?> :</span>
                                    <span>+<?php echo e($booking->user ? $booking->user->mobile : $booking->guest_details->mobile); ?></span>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="float-right">
                        <ul class="text-end">
                            <li>
                                <h5 class="primary-text d-block fw-md"> <?php echo app('translator')->get('Bill Information'); ?> </h5>
                            </li>

                            <li>
                                <span class="d-inline-block strong"><?php echo app('translator')->get('Booking No'); ?> :</span>
                                <span class="d-inline-block"><?php echo e($booking->booking_number); ?></span>
                            </li>

                            <li>
                                <span class="d-inline-block strong"><?php echo app('translator')->get('Total Amount'); ?> :</span>
                                <span class="d-inline-block"><?php echo e(showAmount($booking->total_amount)); ?> <?php echo e(__($general->cur_text)); ?></span>
                            </li>
                            <li>
                                <span class="d-inline-block strong"><?php echo app('translator')->get('Paid Amount'); ?> :</span>
                                <span class="d-inline-block"><?php echo e(showAmount($booking->paid_amount)); ?> <?php echo e(__($general->cur_text)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="body">
                    <h5 class="title"><?php echo app('translator')->get('Room\'s Details'); ?></h5>
                    <table class="table-bordered custom-table table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Room No.'); ?></th>
                                <th><?php echo app('translator')->get('Room Type'); ?></th>
                                <th><?php echo app('translator')->get('Fare'); ?></th>
                            </tr>
                        </thead>
                        <?php
                            $activeBookedRooms = $booking->activeBookedRooms->groupBy('booked_for');
                            $totalFare = $booking->activeBookedRooms->sum('fare');
                        ?>

                        <tbody>
                            <?php $__currentLoopData = $activeBookedRooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="custom-table__subhead">
                                    <td colspan="3" style="text-align: center;">
                                        <?php echo e(__(showDateTime($key, 'd M, Y'))); ?>

                                    </td>
                                </tr>
                                <?php $__currentLoopData = $item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booked): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-start"><?php echo e(__($booked->room->room_number)); ?></td>
                                        <td><?php echo e(__($booked->room->roomType->name)); ?></td>
                                        <td><?php echo e(__(showAmount($booked->fare))); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="custom-table__subhead">
                                <td class="text-end" colspan="2"><?php echo app('translator')->get('Total Fare'); ?></td>
                                <td><?php echo e(showAmount($totalFare)); ?> <?php echo e(__($general->cur_text)); ?></td>
                            </tr>

                            <?php if(!$extraService): ?>

                                <?php if($booking->cancellation_fee > 0): ?>
                                    <tr class="custom-table__subhead">
                                        <td class="text-end" colspan="2"><?php echo app('translator')->get('Cancellation Fee'); ?></td>
                                        <td><?php echo e(showAmount($booking->cancellation_fee)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="custom-table__subhead">
                                    <td class="text-end" colspan="2"><?php echo e(__($general->tax_name)); ?></td>
                                    <td><?php echo e(showAmount($booking->tax_charge)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                </tr>
                                <?php if($booking->extraCharge() > 0): ?>
                                    <tr class="custom-table__subhead">
                                        <td class="text-end" colspan="2"><?php echo app('translator')->get('Other Charges'); ?></td>
                                        <td><?php echo e(showAmount($booking->extraCharge())); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endif; ?>

                                <tr class="custom-table__subhead">
                                    <td class="text-end" colspan="2"><?php echo app('translator')->get('Total'); ?></td>
                                    <td><?php echo e(showAmount($booking->total_amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                </tr>

                                <?php if($due > 0): ?>
                                    <tr class="custom-table__subhead">
                                        <td class="text-end" colspan="2"><?php echo app('translator')->get('Due'); ?></td>
                                        <td><?php echo e(showAmount($due)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php elseif($due < 0): ?>
                                    <tr class="custom-table__subhead">
                                        <td class="text-end" colspan="2"><?php echo app('translator')->get('Refundable'); ?></td>
                                        <td><?php echo e(showAmount(abs($due))); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <?php if($extraService): ?>
                        <?php
                            $extraServices = $booking->usedExtraService->groupBy('service_date');
                        ?>
                        <div class="extra-service">
                            <div class="mt-10">
                                <h5 class="title"><?php echo app('translator')->get('Service Details'); ?></h5>
                            </div>
                            <table class="table-bordered custom-table table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Room No.'); ?></th>
                                        <th><?php echo app('translator')->get('Service'); ?></th>
                                        <th><?php echo app('translator')->get('Quantity'); ?></th>
                                        <th><?php echo app('translator')->get('Unit Price'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $extraServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $serviceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="custom-table__subhead">
                                            <td colspan="5" style="text-align: center;"><?php echo e(__(showDateTime($key, 'd M, Y'))); ?></td>
                                        </tr>
                                        <?php $__currentLoopData = $serviceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(__($service->room->room_number)); ?></td>
                                                <td><?php echo e(__($service->extraService->name)); ?></td>
                                                <td><?php echo e($service->qty); ?></td>
                                                <td><?php echo e(showAmount($service->unit_price)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                                <td><?php echo e(showAmount($service->total_amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="custom-table__subhead">
                                        <td class="text-end" colspan="4"><?php echo app('translator')->get('Total Charge'); ?></td>
                                        <td><?php echo e(showAmount($booking->service_cost)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="summary avoid_page_break">
                            <div class="mt-10">
                                <h5 class="title"><?php echo app('translator')->get('Billing Details'); ?></h5>
                            </div>
                            <table class="table-bordered custom-table table">
                                <tbody>
                                    <tr>
                                        <td class="text-end"><?php echo app('translator')->get('Total Fare'); ?></td>
                                        <td><?php echo e(showAmount($totalFare)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                    <?php if($booking->cancellation_fee > 0): ?>
                                        <tr>
                                            <td class="text-end"><?php echo app('translator')->get('Cancellation Fee'); ?></td>
                                            <td><?php echo e(showAmount($booking->cancellation_fee)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td class="text-end"><?php echo e(__($general->tax_name)); ?> <?php echo app('translator')->get('Charge'); ?></td>
                                        <td><?php echo e(showAmount($booking->tax_charge)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-end"><?php echo app('translator')->get('Service Charge'); ?></td>
                                        <td><?php echo e(showAmount($booking->service_cost)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                    <?php if($booking->extraCharge() > 0): ?>
                                        <tr>
                                            <td class="text-end"><?php echo app('translator')->get('Other Charges'); ?></td>
                                            <td><?php echo e(showAmount($booking->extraCharge())); ?> <?php echo e(__($general->cur_text)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td class="text-end"><?php echo app('translator')->get('Total'); ?></td>
                                        <td><?php echo e(showAmount($booking->total_amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>

                                    <?php if($due > 0): ?>
                                        <tr class="text-end">
                                            <td class="text-end"><?php echo app('translator')->get('Due'); ?></td>
                                            <td><?php echo e(showAmount($due)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                        </tr>
                                    <?php elseif($due < 0): ?>
                                        <tr class="text-end">
                                            <td class="text-end"><?php echo app('translator')->get('Refundable'); ?></td>
                                            <td><?php echo e(showAmount(abs($due))); ?> <?php echo e(__($general->cur_text)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</body>

</html>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/partials/invoice.blade.php ENDPATH**/ ?>