<?php
$content = getContent('featured_room.content', true);

$roomType = App\Models\RoomType::active()
    ->featured()
    ->with(['images', 'amenities'])
    ->get();
?>

<?php if(count($roomType)): ?>
    <section class="section section--bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7 text-center">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo e(__($content->data_values->heading)); ?></h2>
                        <p><?php echo e(__($content->data_values->subheading)); ?></p>
                    </div>
                </div>
            </div>
            <div class="row g-4 justify-content-center">
                <!-- room section start -->
                <?php echo $__env->make($activeTemplate.'partials.room_cards', ['roomType' => $roomType, 'class' => 'col-lg-6 col-xl-4 col-md-8'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- room section end -->
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/sections/featured_room.blade.php ENDPATH**/ ?>