<?php $__env->startSection('panel'); ?>
    <div class="row">
        <?php $hasPermission = App\Models\Role::hasPermission('admin.room.search')  ? 1 : 0;
            if($hasPermission == 1): ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.room.search')); ?>" class="formRoomSearch" method="get">
                            <div class="d-flex justify-content-between align-items-end flex-wrap gap-2">
                                <div class="form-group flex-fill">
                                    <label><?php echo app('translator')->get('Room Type'); ?></label>
                                    <select class="form-control" name="room_type" required>
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $roomTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group flex-fill">
                                    <label><?php echo app('translator')->get('Check In - Check Out Date'); ?></label>
                                    <input autocomplete="off" class="datepicker-here form-control bg--white" data-language="en" data-multiple-dates-separator=" - " data-position='bottom left' data-range="true" name="date" placeholder="<?php echo app('translator')->get('Select Date'); ?>" required type="text">
                                </div>
                                <div class="form-group flex-fill">
                                    <label><?php echo app('translator')->get('Room'); ?></label>
                                    <input class="form-control" name="rooms" placeholder="<?php echo app('translator')->get('How many room?'); ?>" required type="text">
                                </div>

                                <div class="form-group flex-fill">
                                    <button class="btn btn--primary w-100 h-45 search" type="submit">
                                        <i class="la la-search"></i><?php echo app('translator')->get('Search'); ?>
                                    </button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        <?php endif ?>
    </div>
    <div class="row booking-wrapper d-none">
        <div class="col-lg-8 mt-3">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-flex justify-content-between booking-info-title mb-0">
                        <h5><?php echo app('translator')->get('Booking Information'); ?></h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="pb-3">
                        <span class="fas fa-circle text--danger" disabled></span>
                        <span class="mr-5"><?php echo app('translator')->get('Booked'); ?></span>
                        <span class="fas fa-circle text--success"></span>
                        <span class="mr-5"><?php echo app('translator')->get('Selected'); ?></span>
                        <span class="fas fa-circle text--primary"></span>
                        <span><?php echo app('translator')->get('Available'); ?></span>
                    </div>
                    <div class="alert alert-info room-assign-alert p-3" role="alert">
                    </div>
                    <div class="bookingInfo">

                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mt-3">
            <div class="card">
                <div class="card-header">
                    <div class="card-title mb-0">
                        <h5><?php echo app('translator')->get('Book Room'); ?></h5>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.room.book')); ?>" class="booking-form" id="booking-form" method="POST">
                        <?php echo csrf_field(); ?>
                        <input name="room_type_id" type="hidden">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Guest Type'); ?></label>
                                    <select class="form-control" name="guest_type">
                                        <option selected value="0"><?php echo app('translator')->get('Walk-In Guest'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('Existing Guest'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-12 guestInputDiv">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Name'); ?></label>
                                    <input class="form-control forGuest" name="guest_name" required type="text">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Email'); ?></label>
                                    <input class="form-control" name="email" required type="email">
                                </div>
                            </div>

                            <div class="col-12 guestInputDiv">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Phone Number'); ?></label>
                                    <input class="form-control forGuest" name="mobile" required type="number">
                                </div>
                            </div>
                            <div class="col-12 guestInputDiv">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Address'); ?></label>
                                    <input class="form-control forGuest" name="address" required type="text">
                                </div>
                            </div>

                            <div class="orderList d-none">
                                <ul class="list-group list-group-flush orderItem">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <h6><?php echo app('translator')->get('Room'); ?></h6>
                                        <h6><?php echo app('translator')->get('Days'); ?></h6>
                                        <span>
                                            <h6><?php echo app('translator')->get('Fare'); ?></h6>
                                        </span>
                                        <span>
                                            <h6><?php echo app('translator')->get('Subtotal'); ?></h6>
                                        </span>
                                    </li>
                                </ul>
                                <div class="d-flex justify-content-between align-items-center border-top p-2">
                                    <span><?php echo app('translator')->get('Subtotal'); ?></span>
                                    <span class="totalFare" data-amount="0"></span>
                                </div>

                                <div class="d-flex justify-content-between align-items-center border-top p-2">
                                    <span><?php echo e($general->tax_name); ?> <small>(<?php echo e($general->tax); ?>%)</small></span>
                                    <span><span class="taxCharge" data-percent_charge="<?php echo e($general->tax); ?>"></span> <?php echo e($general->cur_text); ?></span>
                                    <input name="tax_charge" type="hidden">
                                </div>

                                <div class="d-flex justify-content-between align-items-center border-top p-2">
                                    <span><?php echo app('translator')->get('Total Fare'); ?></span>
                                    <span class="grandTotalFare"></span>
                                    <input hidden name="total_amount" type="text">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Paying Amount'); ?></label>
                                    <input class="form-control" min="0" name="paid_amount" placeholder="<?php echo app('translator')->get('Paying Amount'); ?>" step="any" type="number">
                                </div>
                            </div>
                            <?php $hasPermission = App\Models\Role::hasPermission('admin.room.book')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                <div class="form-group mb-0">
                                    <button class="btn btn--primary h-45 w-100 btn-book confirmBookingBtn" type="button"><?php echo app('translator')->get('Book Now'); ?></button>
                                </div>
                            <?php endif ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirmBookingModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                    <button aria-label="Close" class="close" data-bs-dismiss="modal" type="button">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to book this rooms?'); ?></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                    <button class="btn btn--primary btn-confirm" type="button"><?php echo app('translator')->get('Yes'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $hasPermission = App\Models\Role::hasPermission('admin.booking.all')  ? 1 : 0;
            if($hasPermission == 1): ?>
    <?php $__env->startPush('breadcrumb-plugins'); ?>
        <a class="btn btn-sm btn--primary" href="<?php echo e(route('admin.booking.all')); ?>">
            <i class="la la-list"></i><?php echo app('translator')->get('All Bookings'); ?>
        </a>
    <?php $__env->stopPush(); ?>
<?php endif ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/global/css/vendor/datepicker.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/vendor/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/vendor/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .booking-table td {
            white-space: unset;
        }

        .modal-open .select2-container {
            z-index: 9 !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        if (!$('.datepicker-here').val()) {
            $('.datepicker-here').datepicker({
                minDate: new Date()
            });
        }


        $('[name=guest_type]').on('change', function() {
            if ($(this).val() == 1) {
                $('.guestInputDiv').addClass('d-none');
                $('.forGuest').attr("required", false);
            } else {
                $('.guestInputDiv').removeClass('d-none');
                $('.forGuest').attr("required", true);
            }
        });


        $('.formRoomSearch').on('submit', function(e) {
            e.preventDefault();

            let searchDate = $('[name=date]').val();
            if (searchDate.split(" - ").length < 2) {
                notify('error', `<?php echo app('translator')->get('Check-In date and checkout date should be given for booking.'); ?>`);
                return false;
            }

            resetDOM();
            let formData = $(this).serialize();
            let url = $(this).attr('action');

            $.ajax({
                type: "get",
                url: url,
                data: formData,
                success: function(response) {
                    $('.bookingInfo').html('');
                    $('.booking-wrapper').addClass('d-none');
                    if (response.error) {
                        notify('error', response.error);
                    } else if (response.html.error) {
                        notify('error', response.html.error);
                    } else {
                        $('.bookingInfo').html(response.html);
                        let roomTypeId = $('[name=room_type]').val();
                        $('[name=room_type_id]').val(roomTypeId);
                        $('.booking-wrapper').removeClass('d-none');
                    }
                },
                processData: false,
                contentType: false,
            });
        });

        function resetDOM() {
            $(document).find('.orderListItem').remove();
            $('.totalFare').data('amount', 0);
            $('.totalFare').text(`0 <?php echo e(__($general->cur_text)); ?>`);
            $('.taxCharge').text('0');
            $('[name=tax_charge]').val('0');
            $('.grandTotalFare').text(`0 <?php echo e(__($general->cur_text)); ?>`);
            $('[name=total_amount]').val('0');
            $('[name=paid_amount]').val('');
            $('[name=room_type_id]').val('');
        }

        $(document).on('click', '.confirmBookingBtn', function() {
            var modal = $('#confirmBookingModal');
            modal.modal('show');
        });

        $('.btn-confirm').on('click', function() {
            $('#confirmBookingModal').modal('hide');
            $('.booking-form').submit();
        });

        $('.booking-form').on('submit', function(e) {
            e.preventDefault();
            let formData = $(this).serialize();
            let url = $(this).attr('action');
            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function(response) {
                    if (response.success) {
                        notify('success', response.success);
                        $('.bookingInfo').html('');
                        $('.booking-wrapper').addClass('d-none');
                        $(document).find('.orderListItem').remove();
                        $('.orderList').addClass('d-none');
                        $('.formRoomSearch').trigger('reset');
                    } else {
                        notify('error', response.error);
                    }
                },
            });
        });
        $('.select2-basic').select2({
            dropdownParent: $('.select2-parent')
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/admin/booking/book.blade.php ENDPATH**/ ?>