<?php
$customCaptcha = loadCustomCaptcha();
$googleCaptcha = loadReCaptcha();
?>
<?php if($googleCaptcha): ?>
    <div class="mb-3">
        <?php echo $googleCaptcha ?>
    </div>
<?php endif; ?>

<?php if($customCaptcha): ?>
    <div class="mb-2">
        <?php echo $customCaptcha ?>
    </div>

    <div class="form-group">
        <label><?php echo app('translator')->get('Captcha'); ?></label>
        <input type="text" class="form-control form--control" name="captcha" <?php if($placeholder): ?> placeholder="<?php echo app('translator')->get('Enter the above code here'); ?>" <?php endif; ?> required>
    </div>
<?php endif; ?>

<?php if($googleCaptcha): ?>
    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict"
                $('.verify-gcaptcha').on('submit', function() {
                    var response = grecaptcha.getResponse();
                    if (response.length == 0) {
                        document.getElementById('g-recaptcha-error').innerHTML = `<span class="text-danger"><?php echo app('translator')->get('Captcha field is required.'); ?></span>`;
                        return false;
                    }
                    return true;
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/partials/captcha.blade.php ENDPATH**/ ?>