<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($general->siteName('Thermal Invoice')); ?></title>
    <style>
        * { margin: 1px 0px 0px 0px; padding: 0; box-sizing: border-box; font-family: 'Courier New', monospace; }
        body {
            font-size: 12px;
            width: 93%;
            padding: 8px 10px; /* adds top/bottom + left/right margin */
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .divider { border-top: 1px dashed #000; margin: 10px 0; }
        .section { margin-bottom: 15px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { text-align: left; padding: 2px 0; }
        th { border-bottom: 1px solid #000; font-weight: bold; }
        .right { text-align: right; }
        .total-line td { border-top: 1px dashed #000; font-weight: bold; }
        .footer { text-align: center; margin-top: 12px; font-size: 11px; }
    </style>
</head>

<body>
    <?php
        $guest = is_string($booking->guest_details)
            ? json_decode($booking->guest_details)
            : $booking->guest_details;
        $extraService = count($booking->usedExtraService);
        $due = $booking->total_amount - $booking->paid_amount;
    ?>

    <div class="center">
        <h3><?php echo e($general->sitename); ?></h3>
        <p><?php echo e($general->address ?? ''); ?></p>
        <p><small><?php echo e(date('d M, Y h:i A')); ?></small></p>
    </div>

    <div class="divider"></div>

    <div class="section">
        <p><span class="bold">Booking No:</span> <?php echo e($booking->booking_number); ?></p>
        <p><span class="bold">Guest:</span> <?php echo e(optional($booking->user)->firstname ?? ($guest->name ?? 'N/A')); ?></p>
        <p><span class="bold">Email:</span> <?php echo e(optional($booking->user)->email ?? ($guest->email ?? 'N/A')); ?></p>
        <p><span class="bold">Phone:</span> <?php echo e(optional($booking->user)->mobile ?? ($guest->mobile ?? 'N/A')); ?></p>
        <p><span class="bold">Check In:</span> <?php echo e(showDateTime($booking->check_in, 'd M, Y')); ?></p>
        <p><span class="bold">Check Out:</span> <?php echo e(showDateTime($booking->check_out, 'd M, Y')); ?></p>
    </div>

    <div class="divider"></div>

    <?php
        $activeBookedRooms = $booking->activeBookedRooms->groupBy('booked_for');
        $totalFare = $booking->activeBookedRooms->sum('fare');
    ?>

    <div class="section">
        <h4 class="center">Room Details</h4>
        <table>
            <thead>
                <tr>
                    <th>Room</th>
                    <th>Type</th>
                    <th class="right">Fare</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $activeBookedRooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rooms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr><td colspan="3" class="center"><small><?php echo e(showDateTime($key, 'd M, Y')); ?></small></td></tr>
                    <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($room->room->room_number); ?></td>
                            <td><?php echo e($room->room->roomType->name); ?></td>
                            <td class="right"><?php echo e(showAmount($room->fare)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr class="total-line">
                    <td colspan="2">Total Fare</td>
                    <td class="right"><?php echo e(showAmount($totalFare)); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <?php if($extraService): ?>
        <div class="divider"></div>
        <div class="section">
            <h4 class="center">Extra Services</h4>
            <?php $extraGroups = $booking->usedExtraService->groupBy('service_date'); ?>
            <table>
                <thead>
                    <tr>
                        <th>Room</th>
                        <th>Service</th>
                        <th class="right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $extraGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr><td colspan="3" class="center"><small><?php echo e(showDateTime($date, 'd M, Y')); ?></small></td></tr>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $srv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($srv->room->room_number); ?></td>
                                <td><?php echo e($srv->extraService->name); ?></td>
                                <td class="right"><?php echo e(showAmount($srv->total_amount)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr class="total-line">
                        <td colspan="2">Service Total</td>
                        <td class="right"><?php echo e(showAmount($booking->service_cost)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <div class="divider"></div>

    <div class="section">
        <h4 class="center">Billing Summary</h4>
        <table>
            <tbody>
                <?php if($booking->cancellation_fee > 0): ?>
                    <tr><td>Cancellation Fee</td><td class="right"><?php echo e(showAmount($booking->cancellation_fee)); ?></td></tr>
                <?php endif; ?>
                <tr><td><?php echo e(__($general->tax_name)); ?></td><td class="right"><?php echo e(showAmount($booking->tax_charge)); ?></td></tr>
                <?php if($booking->extraCharge() > 0): ?>
                    <tr><td>Other Charges</td><td class="right"><?php echo e(showAmount($booking->extraCharge())); ?></td></tr>
                <?php endif; ?>
                <tr><td>Total</td><td class="right"><?php echo e(showAmount($booking->total_amount)); ?></td></tr>
                <tr><td>Paid</td><td class="right"><?php echo e(showAmount($booking->paid_amount)); ?></td></tr>
                <?php if($due > 0): ?>
                    <tr><td>Due</td><td class="right"><?php echo e(showAmount($due)); ?></td></tr>
                <?php elseif($due < 0): ?>
                    <tr><td>Refundable</td><td class="right"><?php echo e(showAmount(abs($due))); ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="divider"></div>

    <div class="footer">
        <p>Thank you for choosing us.</p>
        <p><small>Printed on <?php echo e(now()->format('d M, Y h:i A')); ?></small></p>
    </div>
    
    
    <div class="footer">
        <p></br></p>
    </div>
    
</body>
</html>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/partials/invoice_thermal.blade.php ENDPATH**/ ?>