<?php
$subscribeContent = getContent('subscribe.content', true);
?>
<section class="section base--overlay bg_img" style="background-image: url('<?php echo e(getImage('assets/images/frontend/subscribe/' . @$subscribeContent->data_values->image, '1800x300')); ?>');">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <h2 class="section-title text-center text-white"><?php echo e(__(@$subscribeContent->data_values->heading)); ?></h2>
                <form action="" class="subscribe-form" id="subscribe">
                    <?php echo csrf_field(); ?>
                    <input type="email" name="email" class="form--control" placeholder="<?php echo app('translator')->get('Enter email address'); ?>">
                    <button type="submit" class="btn btn--dark"><i class="fa fa-paper-plane" aria-hidden="true"></i> &nbsp; <?php echo e(__(@$subscribeContent->data_values->button_title)); ?></button>
                </form>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
    <script type="text/javascript">
        $('.subscribe-form').on('submit', function(e) {
            e.preventDefault();
            let url = `<?php echo e(route('subscribe')); ?>`;

            let data = {
                email: $(this).find('input[name=email]').val()
            };
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': `<?php echo e(csrf_token()); ?>`
                }
            });
            $.post(url, data, function(response) {
                if (response.errors) {
                    for (var i = 0; i < response.errors.length; i++) {
                        iziToast.error({
                            message: response.errors[i],
                            position: "topRight"
                        });
                    }
                } else {
                    $('.subscribe-form').trigger("reset");
                    iziToast.success({
                        message: response.success,
                        position: "topRight"
                    });
                }
            });
            this.reset();
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/sections/subscribe.blade.php ENDPATH**/ ?>