<?php
    $content  = getContent('faq.content', true);
    $elements = getContent('faq.element', false);
?>

<section class="section section--bg">
    <div class="container">
        <?php if(Request::path() != 'faq'): ?>
            <div class="row justify-content-center">
                <div class="col-lg-7 text-center">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo e(__($content->data_values->heading)); ?></h2>
                        <p><?php echo e(__($content->data_values->subheading)); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row gy-4 justify-content-center">
            <div class="accordion custom--accordion" id="faqAccordion1">
                <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h6 class="accordion-header collapsed" id="heading<?php echo e($item->id); ?>">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse<?php echo e($item->id); ?>" aria-expanded="false"
                                aria-controls="collapse<?php echo e($item->id); ?>">
                                <?php echo e(__($item->data_values->question)); ?>

                            </button>
                        </h6>
                        <div id="collapse<?php echo e($item->id); ?>" class="accordion-collapse collapse"
                            aria-labelledby="heading<?php echo e($item->id); ?>" data-bs-parent="#faqAccordion1">
                            <div class="accordion-body">
                                <p><?php echo e(__($item->data_values->answer)); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>