<?php
$blogContent  = getContent('blog.content', true);
$blogElements = getContent('blog.element', false, 3, true);
?>

<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7 text-center">
                <div class="section-header">
                    <h2 class="section-title"><?php echo e(__($blogContent->data_values->heading)); ?></h2>
                    <p><?php echo e(__($blogContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $blogElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="blog-post">
                        <div class="blog-post__thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/blog/thumb_' . $blog->data_values->image, '400x280')); ?>" alt="image">
                        </div>
                        <div class="blog-post__content">
                            <ul class="blog-meta">
                                <li><?php echo e(showDateTime($blog->creatd_at, 'd M, Y')); ?></li>
                            </ul>

                            <h5 class="title">
                                <a href="<?php echo e(route('blog.details', [slug($blog->data_values->title), $blog->id])); ?>"> <?php echo substr(trans($blog->data_values->title),0,60) ?></a>
                            </h5>

                            <p><?php echo strLimit(strip_tags($blog->data_values->description), 100)  ?></p>

                            <a href="<?php echo e(route('blog.details', [slug($blog->data_values->title), $blog->id])); ?>" class="mt-3"><?php echo app('translator')->get('Read More'); ?> <i class="las la-long-arrow-alt-right"></i></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/sections/blog.blade.php ENDPATH**/ ?>