<?php $__env->startSection('panel'); ?>
    <?php
        $totalFare = $booking->bookedRooms->sum('fare');
        $totalTaxCharge = $booking->bookedRooms->sum('tax_charge');
        $canceledFare = $booking->bookedRooms->where('status', Status::ROOM_CANCELED)->sum('fare');
        $canceledTaxCharge = $booking->bookedRooms->where('status', Status::ROOM_CANCELED)->sum('tax_charge');
        $due = $booking->total_amount - $booking->paid_amount;
    ?>

    <div class="row gy-4">
        <div class="col-md-4 ">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex flex-column gap-3">

                        <div>
                            <small class="fw-500"> <i class="las la-user-edit"></i> <?php echo app('translator')->get('Guest Type'); ?></small><br>
                            <?php if($booking->user_id): ?>
                                <span class="d-bock"><?php echo app('translator')->get('Registered Guest'); ?></span>
                            <?php else: ?>
                                <span class="d-bock"><?php echo app('translator')->get('Walk In Guest'); ?></span>
                            <?php endif; ?>
                        </div>

                        <div>

                            <small class="fw-500"> <i class="la la-user"></i> <?php echo app('translator')->get('Name'); ?></small><br>
                            <?php if($booking->user_id): ?>
                                <a class="fw-bold d-block text--primary" href="<?php echo e(can('admin.users.detail') ? route('admin.users.detail', $booking->user_id) : 'javascript:void(0)'); ?>"><?php echo e($booking->user->fullname); ?></a>
                            <?php else: ?>
                                <span class="d-block"><?php echo e($booking->guest_details->name); ?></span>
                            <?php endif; ?>
                        </div>

                        <div>
                            <small class="fw-500"><i class="la la-envelope"></i> <?php echo app('translator')->get('Email'); ?></small><br>
                            <?php if($booking->user_id): ?>
                                <span class="d-block"><?php echo e($booking->user->email); ?></span>
                            <?php else: ?>
                                <span class="d-block"><?php echo e($booking->guest_details->email); ?></span>
                            <?php endif; ?>
                        </div>

                        <div>
                            <small class="fw-500"><i class="la la-mobile"></i> <?php echo app('translator')->get('Mobile'); ?></small>

                            <span class="d-block">
                                <?php if($booking->user_id): ?>
                                    +<?php echo e($booking->user->mobile); ?>

                                <?php else: ?>
                                    +<?php echo e($booking->guest_details->mobile); ?>

                                <?php endif; ?>
                            </span>
                        </div>

                        <?php
                            $address = $booking->user_id ? $booking->user->address->address : @$booking->guest_details->address;
                        ?>

                        <div>
                            <small class="fw-500"><i class="la la-map"></i> <?php echo app('translator')->get('Address'); ?></small> <br>
                            <span>
                                <?php echo e($address ?? __('N/A')); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card position-relative">
                <div class="card-body">
                    <div class="custom-badge position-absolute">
                        <?php
                            echo $booking->status_badge;
                        ?>
                    </div>

                    <div class="d-flex flex-wrap justify-content-between gap-3">
                        <div class="d-flex flex-column gap-3">
                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Booking No.'); ?></small> <br>
                                <span>#<?php echo e($booking->booking_number); ?></span>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Total Room'); ?></small> <br>
                                <span><?php echo e($booking->bookedRooms->count()); ?></span>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Total Charge'); ?></small> <br>
                                <span><?php echo e(showAmount($booking->total_amount)); ?> <?php echo e(__($general->cur_text)); ?></span>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Paid Amount'); ?></small> <br>
                                <span><?php echo e(showAmount($booking->paid_amount)); ?> <?php echo e(__($general->cur_text)); ?></span>
                            </div>

                            <div>
                                <?php if($due < 0): ?>
                                    <small class="fw-500"><?php echo app('translator')->get('Refundable'); ?> </small> <br>
                                    <span class="text--warning"><?php echo e($general->cur_sym . showAmount(abs($due))); ?></span>
                                <?php else: ?>
                                    <small class="fw-500"><?php echo app('translator')->get('Receivable from User'); ?></small><br>
                                    <span class="<?php if($due > 0): ?> text--danger <?php else: ?> text--success <?php endif; ?>"> <?php echo e($general->cur_sym . showAmount(abs($due))); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="d-flex flex-column gap-3">
                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Booked At'); ?></small> <br>
                                <small> <em class="text-muted"><?php echo e(showDateTime($booking->created_at, 'd M, Y h:i A')); ?></em></small>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Check-In'); ?></small> <br>
                                <small><em><?php echo e(showDateTime($booking->check_in, 'd M, Y')); ?></em></small>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Checkout'); ?></small> <br>
                                <small><em><?php echo e(showDateTime($booking->check_out, 'd M, Y')); ?></em></small>
                            </div>

                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Checked-In At'); ?></small> <br>
                                <small> <em class="text-muted"><?php echo e(showDateTime($booking->checked_in_at, 'd M, Y h:i A')); ?></em></small>
                            </div>
                            <div>
                                <small class="fw-500"><?php echo app('translator')->get('Checked Out At'); ?></small> <br>
                                <small> <em class="text-muted">
                                        <?php if($booking->checked_out_at): ?>
                                            <?php echo e(showDateTime($booking->checked_out_at, 'd M, Y h:i A')); ?>

                                        <?php else: ?>
                                            <?php echo app('translator')->get('N/A'); ?>
                                        <?php endif; ?>
                                    </em>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="col-12">
            <div class="accordion d-flex flex-column gap-4">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="bookedRoomsHeading">
                        <button aria-controls="bookedRooms" aria-expanded="true" class="accordion-button" data-bs-target="#bookedRooms" data-bs-toggle="collapse" type="button">
                            <?php echo app('translator')->get('Booked Rooms'); ?>
                        </button>
                    </h2>
                    <div aria-labelledby="bookedRoomsHeading" class="accordion-collapse collapse show" data-bs-parent="#s" id="bookedRooms">
                        <div class="accordion-body p-0">
                            <div class="table-responsive--sm">
                                <table class="custom--table table table-striped">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?php echo app('translator')->get('Booked For'); ?></th>
                                            <th><?php echo app('translator')->get('Room Type'); ?></th>
                                            <th><?php echo app('translator')->get('Room No.'); ?></th>
                                            <th class="text-end"><?php echo app('translator')->get('Fare'); ?> / <?php echo app('translator')->get('Night'); ?></th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php $__currentLoopData = $booking->bookedRooms->groupBy('booked_for'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bookedRoom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $bookedRoom; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booked): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <?php if($loop->first): ?>
                                                        <td class="bg--date text-center" rowspan="<?php echo e(count($bookedRoom)); ?>">
                                                            <?php echo e(showDateTime($booked->booked_for, 'd M, Y')); ?>

                                                        </td>
                                                    <?php endif; ?>

                                                    <td class="text-center" data-label="<?php echo app('translator')->get('Room Type'); ?>">
                                                        <?php echo e(__($booked->room->roomType->name)); ?>

                                                    </td>
                                                    <td data-label="<?php echo app('translator')->get('Room No.'); ?>">
                                                        <?php echo e(__($booked->room->room_number)); ?>

                                                        <?php if($booked->status == Status::ROOM_CANCELED): ?>
                                                            <span class="text--danger text-sm">(<?php echo app('translator')->get('Canceled'); ?>)</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-end" data-label="<?php echo app('translator')->get('Fare'); ?>">
                                                        <?php echo e($general->cur_sym . showAmount($booked->fare)); ?>

                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-end" colspan="3">
                                                <span class="fw-bold"><?php echo app('translator')->get('Total Fare'); ?></span>
                                            </td>

                                            <td class="fw-bold text-end">
                                                <?php echo e($general->cur_sym . showAmount($totalFare)); ?>

                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="extraServiceHeading">
                        <button aria-controls="extraServices" aria-expanded="false" class="accordion-button" data-bs-target="#extraServices" data-bs-toggle="collapse" type="button">
                            <?php echo app('translator')->get('Extra Services'); ?>
                        </button>
                    </h2>
                    <div aria-labelledby="extraServiceHeading" class="accordion-collapse collapse show" data-bs-parent="#s" id="extraServices">
                        <div class="accordion-body p-0">
                            <?php if($booking->usedExtraService->count()): ?>
                                <div class="table-responsive--sm">
                                    <table class="custom--table head--base table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo app('translator')->get('Date'); ?></th>
                                                <th><?php echo app('translator')->get('Room No.'); ?></th>
                                                <th><?php echo app('translator')->get('Service'); ?></th>
                                                <th><?php echo app('translator')->get('Total'); ?></th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php $__currentLoopData = $booking->usedExtraService->groupBy('service_date'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <?php if($loop->first): ?>
                                                            <td class="bg--date text-center" data-label="<?php echo app('translator')->get('Date'); ?>" rowspan="<?php echo e(count($services)); ?>">
                                                                <?php echo e(showDateTime($service->service_date, 'd M, Y')); ?>

                                                            </td>
                                                        <?php endif; ?>

                                                        <td data-label="<?php echo app('translator')->get('Room No.'); ?>">
                                                            <span class="fw-bold"><?php echo e(__($service->room->room_number)); ?></span>
                                                        </td>
                                                        <td data-label="<?php echo app('translator')->get('Service'); ?>">
                                                            <span class="fw-bold">
                                                                <?php echo e(__($service->extraService->name)); ?>

                                                            </span>
                                                            <br>
                                                            <?php echo e($general->cur_sym . showAmount($service->unit_price)); ?> x <?php echo e($service->qty); ?>

                                                        </td>
                                                        <td data-label="<?php echo app('translator')->get('Total'); ?>">
                                                            <span class="fw-bold text-end">
                                                                <?php echo e($general->cur_sym . showAmount($service->total_amount)); ?>

                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <tr>
                                                <td class="text-end" colspan="3">
                                                    <span class="fw-bold"><?php echo app('translator')->get('Total'); ?></span>
                                                </td>
                                                <td class="fw-bold text-end">
                                                    <?php echo e($general->cur_sym . showAmount($booking->service_cost)); ?>

                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center">
                                    <h6 class="p-3"><?php echo app('translator')->get('No extra service used'); ?></h6>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <?php
                    $receivedPyaments = $booking->payments->where('type', 'RECEIVED');
                    $returnedPyaments = $booking->payments->where('type', 'RETURNED');
                ?>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="paymentReceived">
                        <button aria-controls="paymentsReceived" aria-expanded="false" class="accordion-button" data-bs-target="#paymentsReceived" data-bs-toggle="collapse" type="button">
                            <?php echo app('translator')->get('Payments Recevied'); ?>
                        </button>
                    </h2>
                    <div aria-labelledby="paymentReceived" class="accordion-collapse collapse show" data-bs-parent="#s" id="paymentsReceived">
                        <div class="accordion-body p-0">
                            <div class="table-responsive--sm">
                                <table class="custom--table head--base table table-striped">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('Time'); ?></th>
                                            <th><?php echo app('translator')->get('Payment Type'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php $__currentLoopData = $receivedPyaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-start"><?php echo e(__(showDateTime($payment->created_at, 'd M, Y H:i A'))); ?></td>
                                                <td>
                                                    <?php if($payment->admin_id == 0): ?>
                                                        <?php echo app('translator')->get('Online Payment'); ?>
                                                    <?php else: ?>
                                                        <?php echo app('translator')->get('Cash Payment'); ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(showAmount($payment->amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            <td class="text-end fw-bold" colspan="2">
                                                <?php echo app('translator')->get('Total'); ?>
                                            </td>
                                            <td class="fw-bold">
                                                <?php echo e(showAmount($receivedPyaments->sum('amount'))); ?> <?php echo e(__($general->cur_text)); ?>

                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="paymentReturned">
                        <button aria-controls="paymentsReturned" aria-expanded="false" class="accordion-button" data-bs-target="#paymentsReturned" data-bs-toggle="collapse" type="button">
                            <?php echo app('translator')->get('Payments Returned'); ?>
                        </button>
                    </h2>
                    <div aria-labelledby="paymentReturned" class="accordion-collapse collapse show" data-bs-parent="#s" id="paymentsReturned">
                        <div class="accordion-body p-0">
                            <table class="custom--table head--base table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Time'); ?></th>
                                        <th><?php echo app('translator')->get('Payment Type'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $returnedPyaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-start"><?php echo e(__(showDateTime($payment->created_at, 'd M, Y H:i A'))); ?></td>
                                            <td>
                                                <?php echo app('translator')->get('Cash Payment'); ?>
                                            </td>
                                            <td><?php echo e(showAmount($payment->amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td class="text-end" colspan="2">
                                            <span class="fw-bold"><?php echo app('translator')->get('Total'); ?></span>
                                        </td>
                                        <td class="fw-bold">
                                            <?php echo e(showAmount($returnedPyaments->sum('amount')) . __($general->cur_text)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="summaryHeading">
                        <button aria-controls="summaryBody" aria-expanded="false" class="accordion-button" data-bs-target="#summaryBody" data-bs-toggle="collapse" type="button">
                            <?php echo app('translator')->get('Payment Info'); ?>
                        </button>
                    </h2>
                    <div aria-labelledby="summaryHeading" class="accordion-collapse collapse show" data-bs-parent="#s" id="summaryBody">
                        <div class="accordion-body p-0">
                            <ul class="list-group list-group-flush">

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Total Fare'); ?></span>
                                    <span> +<?php echo e($general->cur_sym . showAmount($totalFare)); ?></span>
                                </li>
                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo e(__($general->tax_name)); ?> <?php echo app('translator')->get('Charge'); ?> <small>(<?php echo e(showAmount($booking->taxPercentage())); ?>%)</small></span>
                                    <span> +<?php echo e($general->cur_sym . showAmount($totalTaxCharge)); ?></span>
                                </li>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Canceled Tax'); ?></span>
                                    <span> -<?php echo e($general->cur_sym . showAmount($canceledFare)); ?></span>
                                </li>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Canceled'); ?> <?php echo e(__($general->tax_name)); ?> <?php echo app('translator')->get('Charge'); ?></span>
                                    <span> -<?php echo e($general->cur_sym . showAmount($canceledTaxCharge)); ?></span>
                                </li>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Extra Service Charge'); ?></span>
                                    <span> +<?php echo e($general->cur_sym . showAmount($booking->service_cost)); ?></span>
                                </li>

                                <?php if($booking->extraCharge() > 0): ?>
                                    <li class="d-flex justify-content-between list-group-item align-items-start">
                                        <span><?php echo app('translator')->get('Other Charges'); ?></span>
                                        <span> +<?php echo e($general->cur_sym . showAmount($booking->extraCharge())); ?></span>
                                    </li>
                                <?php endif; ?>

                                <?php if($booking->cancellation_fee > 0): ?>
                                    <li class="d-flex justify-content-between list-group-item align-items-start">
                                        <span><?php echo app('translator')->get('Cancellation Fee'); ?></span>
                                        <span> +<?php echo e($general->cur_sym . showAmount($booking->cancellation_fee)); ?></span>
                                    </li>
                                <?php endif; ?>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span class="fw-bold"><?php echo app('translator')->get('Total Amount'); ?></span>
                                    <span class="fw-bold"> = <?php echo e($general->cur_sym . showAmount($booking->total_amount)); ?></span>
                                </li>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Payment Received'); ?></span>
                                    <span><?php echo e($general->cur_sym . showAmount($receivedPyaments->sum('amount'))); ?></span>
                                </li>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <span><?php echo app('translator')->get('Refunded'); ?></span>
                                    <span><?php echo e($general->cur_sym . showAmount($returnedPyaments->sum('amount'))); ?></span>
                                </li>

                                <?php $due = $booking->due(); ?>

                                <li class="d-flex justify-content-between list-group-item align-items-start">
                                    <?php if($due < 0): ?>
                                        <span class="text--warning fw-bold"><?php echo app('translator')->get('Refundable'); ?> </span>
                                        <span class="text--warning fw-bold"><?php echo e($general->cur_sym . showAmount(abs($due))); ?></span>
                                    <?php else: ?>
                                        <span class="<?php if($due > 0): ?> text--danger <?php else: ?> text--success <?php endif; ?> fw-bold"><?php echo app('translator')->get('Receivable from User'); ?></span>
                                        <span class="<?php if($due > 0): ?> text--danger <?php else: ?> text--success <?php endif; ?> fw-bold"> <?php echo e($general->cur_sym . showAmount(abs($due))); ?></span>
                                    <?php endif; ?>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('admin.booking.partials.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>

    <?php $hasPermission = App\Models\Role::hasPermission(['admin.booking.details', 'admin.booking.booked.rooms', 'admin.booking.service.details', 'admin.booking.payment', 'admin.booking.key.handover', 'admin.booking.merge', 'admin.booking.cancel', 'admin.booking.extra.charge', 'admin.booking.checkout', 'admin.booking.invoice', 'admin.booking.all'])  ? 1 : 0;
            if($hasPermission == 1): ?>
        <?php $__env->startPush('breadcrumb-plugins'); ?>
            <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.all')  ? 1 : 0;
            if($hasPermission == 1): ?>
                <a class="btn btn-sm btn--primary" href="<?php echo e(route('admin.booking.all')); ?>">
                    <i class="la la-list"></i><?php echo app('translator')->get('All Bookings'); ?>
                </a>
            <?php endif ?>

            <button aria-expanded="false" class="btn btn-sm btn--info dropdown-toggle" data-bs-toggle="dropdown" type="button">
                <i class="la la-ellipsis-v"></i><?php echo app('translator')->get('More'); ?>
            </button>

            <div class="dropdown-menu">
                <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.booked.rooms')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <a class="dropdown-item" href="<?php echo e(route('admin.booking.booked.rooms', $booking->id)); ?>">
                        <i class="las la-desktop"></i> <?php echo app('translator')->get('Booked Rooms'); ?>
                    </a>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.service.details')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <a class="dropdown-item" href="<?php echo e(route('admin.booking.service.details', $booking->id)); ?>">
                        <i class="las la-server"></i> <?php echo app('translator')->get('Extra Services'); ?>
                    </a>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.payment')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <a class="dropdown-item" href="<?php echo e(route('admin.booking.payment', $booking->id)); ?>">
                        <i class="la la-money-bill"></i> <?php echo app('translator')->get('Payment'); ?>
                    </a>
                <?php endif ?>

                <?php if($booking->status == Status::BOOKING_ACTIVE): ?>
                    <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.key.handover')  ? 1 : 0;
            if($hasPermission == 1): ?>
                        <?php if(now()->format('Y-m-d') >= $booking->check_in && now()->format('Y-m-d') < $booking->check_out && $booking->key_status == Status::DISABLE): ?>
                            <a class="dropdown-item handoverKeyBtn" data-booked_rooms="<?php echo e($booking->activeBookedRooms->unique('room_id')); ?>" data-id="<?php echo e($booking->id); ?>" href="javascript:void(0)">
                                <i class="las la-key"></i> <?php echo app('translator')->get('Handover Keys'); ?>
                            </a>
                        <?php endif; ?>
                    <?php endif ?>

                    <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.merge')  ? 1 : 0;
            if($hasPermission == 1): ?>
                        <a class="dropdown-item mergeBookingBtn" data-booking_number="<?php echo e($booking->booking_number); ?>" data-id="<?php echo e($booking->id); ?>" href="javascript:void(0)">
                            <i class="las la-object-group"></i> <?php echo app('translator')->get('Merge Booking'); ?>
                        </a>
                    <?php endif ?>

                    <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.cancel')  ? 1 : 0;
            if($hasPermission == 1): ?>
                        <a class="dropdown-item" href="<?php echo e(route('admin.booking.cancel', $booking->id)); ?>">
                            <i class="las la-times-circle"></i> <?php echo app('translator')->get('Cancel Booking'); ?>
                        </a>
                    <?php endif ?>

                    <?php $hasPermission = App\Models\Role::hasPermission('admin.booking.checkout')  ? 1 : 0;
            if($hasPermission == 1): ?>
                        <?php if(now() >= $booking->check_out): ?>
                            <a class="dropdown-item" href="<?php echo e(route('admin.booking.checkout', $booking->id)); ?>">
                                <i class="la la-sign-out"></i> <?php echo app('translator')->get('Check Out'); ?>
                            </a>
                        <?php endif; ?>
                    <?php endif ?>
                <?php endif; ?>

                
<?php $hasPermission = App\Models\Role::hasPermission('admin.booking.invoice')  ? 1 : 0;
            if($hasPermission == 1): ?>
    <a class="dropdown-item" href="<?php echo e(route('admin.booking.invoice', $booking->id)); ?>" target="_blank">
        <i class="las la-print"></i> <?php echo app('translator')->get('Print Invoice'); ?>
    </a>

    <a class="dropdown-item" href="<?php echo e(route('admin.booking.thermal.invoice', $booking->id)); ?>" target="_blank">
        <i class="las la-receipt"></i> <?php echo app('translator')->get('Print Thermal'); ?>
    </a>
<?php endif ?>                 
                
            </div>

        <?php $__env->stopPush(); ?>
    <?php endif ?>

    <?php $__env->startPush('style'); ?>
        <style>
            .custom-badge {
                top: -15px;
                left: calc(50% - 75px)
            }

            .custom-badge .badge {
                width: 150px;
                height: 30px;
                line-height: 24px;
                font-size: 1rem !important;
                font-weight: 500;
            }

            .table-striped>tbody>tr:nth-of-type(odd)>* {
                --bs-table-accent-bg: rgb(255 255 255 / 37%);
            }

            .custom--table thead th {
                background-color: #d9d9d9;
            }

            .custom--table th,
            .custom--table td {
                border: 1px solid #e8e8e8;
            }

            .custom--table {
                border: 1px solid #e8e8e8;
                border-collapse: collapse;
            }

            .custom--table tbody td:first-child {
                text-align: center;
            }

            .custom--table tbody td,
            .custom--table thead th {
                color: #5b6e88 !important;
            }

            @media (min-width: 768px) {
                .custom--table tbody td {
                    padding: 0.5rem 1rem !important;
                }

                .custom--table thead th {
                    padding: 1rem !important;
                }
            }

            .accordion-button:focus {
                box-shadow: none;
            }

            .accordion-button:not(.collapsed) {
                color: #fff;
                background-color: #071251;
                font-weight: bold;
            }

            .list-group-item:nth-of-type(odd) {
                background-color: #f9f9f9f2;
            }

            .accordion-button:not(.collapsed)::after {
                filter: brightness(0) invert(1);
            }

            table thead th:first-child {
                border-radius: 0;
            }

            .accordion-item:first-of-type .accordion-button {
                border-radius: unset;
            }

            .accordion-item:has(table) {
                border: 0;
            }
        </style>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/admin/booking/details.blade.php ENDPATH**/ ?>