<?php
    $contactContent = getContent('contact_us.content', true);
    $socialElements = getContent('social_icon.element', false, null, true);
?>

<header class="header">
    <div class="header__top">
        <div class="container">
            <div class="row gy-2 align-items-center">
                <div class="col-lg-5 d-sm-block d-none">
                    <ul class="header-info-list justify-content-lg-start justify-content-center">
                        <li>
                            <a href="mailto:<?php echo e($contactContent->data_values->email_address); ?>"><i class="fas fa-envelope"></i> <?php echo e($contactContent->data_values->email_address); ?></a>
                        </li>

                        <li>
                            <a href="tel:<?php echo e($contactContent->data_values->contact_number); ?>"><i class="fas fa-phone-alt"></i> +<?php echo e($contactContent->data_values->contact_number); ?></a>
                        </li>
                    </ul>
                </div>

                <div class="col-lg-7">
                    <div class="header-top-right justify-content-lg-end justify-content-center">
                        <div class="header-top-action-wrapper">
                            <?php if($general->multi_language): ?>
                                <?php
                                    $language = App\Models\Language::all();
                                ?>
                                <div class="language-select">
                                    <i class="fas fa-globe"></i>
                                    <select class="langSel">
                                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if(session('lang') == $item->code): ?> selected <?php endif; ?> value="<?php echo e($item->code); ?>"><?php echo e(__($item->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php endif; ?>
                            <?php if(auth()->guard()->guest()): ?>
                                <a class="header-user-btn" href="<?php echo e(route('user.login')); ?>"><i class="las la-sign-in-alt"></i> <?php echo app('translator')->get('Login'); ?></a>
                                <a class="header-user-btn ms-2" href="<?php echo e(route('user.register')); ?>"><i class="las la-user"></i>
                                    <?php echo app('translator')->get('Register'); ?></a>
                            <?php endif; ?>

                            <?php if(auth()->guard()->check()): ?>
                                <a class="header-user-btn" href="<?php echo e(route('user.home')); ?>"><i class="la la-dashboard"></i> <?php echo app('translator')->get('Dashboard'); ?></a>
                                <a class="header-user-btn ms-2" href="<?php echo e(route('user.logout')); ?>"><i class="las la-sign-out-alt"></i> <?php echo app('translator')->get('Logout'); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-xl align-items-center">
                <a class="site-logo site-title" href="<?php echo e(route('home')); ?>">
                    <img alt="logo" src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>">
                </a>
                <button aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation" class="navbar-toggler ms-auto" data-bs-target="#navbarSupportedContent" data-bs-toggle="collapse" type="button">

                    <div class="navbar-toggler__icon">
                        <i class="las la-bars"></i>
                    </div>
                </button>
                <div class="collapse navbar-collapse mt-lg-0 mt-3" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu ms-auto">
                        <li><a class="<?php echo e(menuActive('home')); ?>" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('HOME'); ?></a></li>
                        <?php if(@$pages): ?>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="<?php if(request()->url() == route('pages', [$data->slug])): ?> active <?php endif; ?>" href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__(strtoupper($data->name))); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <li>
                            <a class="<?php echo e(menuActive('blog')); ?>" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('UPDATES'); ?></a>
                        </li>

                        <li>
                            <a class="<?php echo e(menuActive('contact')); ?>" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('CONTACT'); ?></a>
                        </li>
                    </ul>
                    <div class="nav-right justify-content-xl-end ps-0 ps-xl-5">
                        <a class="btn btn-sm btn--base" href="<?php echo e(route('room.types')); ?>"><i class="las la-hand-point-right"></i> <?php echo app('translator')->get('BOOK ROOM'); ?></a>

                    </div>

                </div>
            </nav>
        </div>
    </div>
</header>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>