<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Report - A4 Print</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>">
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 14px;
            color: #000;
            background: #fff;
            margin: 20px;
        }
        .report-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .report-header h4 {
            margin: 0;
            font-weight: 600;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px 10px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .totals {
            margin-top: 20px;
            text-align: right;
        }
        .totals td {
            font-weight: bold;
        }
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="report-header">
        <h4>Sales Report</h4>
        <p><?php echo e(date('F d, Y')); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Booking No.</th>
                <th>Guest</th>
                <th>Check In</th>
                <th>Check Out</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Due</th>
                <th>Status</th>
                <th>Room Type</th>
                <th>Room No</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($b->booking_number); ?></td>
                    <td><?php echo e($b->guest_name); ?></td>
                    <td><?php echo e($b->checkin_date); ?></td>
                    <td><?php echo e($b->checkout_date); ?></td>
                    <td><?php echo e(number_format($b->total_amount, 2)); ?></td>
                    <td><?php echo e(number_format($b->total_paid, 2)); ?></td>
                    <td><?php echo e(number_format($b->due, 2)); ?></td>
                    <td><?php echo e(ucfirst($b->status)); ?></td>
                    <td><?php echo e($b->room_type); ?></td>
                    <td><?php echo e($b->room_no); ?></td>
                    <td><?php echo e($b->created_at); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <table class="totals" align="right">
        <tr><td>Total Amount:</td><td><?php echo e(number_format($totals['amount'], 2)); ?></td></tr>
        <tr><td>Total Paid:</td><td><?php echo e(number_format($totals['paid'], 2)); ?></td></tr>
        <tr><td>Total Due:</td><td><?php echo e(number_format($totals['due'], 2)); ?></td></tr>
    </table>

    <div class="no-print text-center mt-3">
        <button onclick="window.print()" class="btn btn-primary btn-sm">Print</button>
        <a href="<?php echo e(route('admin.sales.report')); ?>" class="btn btn-secondary btn-sm">Back</a>
    </div>
</body>
</html>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/admin/reports/print_a4.blade.php ENDPATH**/ ?>