

<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10">
            <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
                <form action="<?php echo e(route('admin.sales.report')); ?>" method="GET" class="d-flex flex-wrap gap-2">
                    <div>
                        <label class="form-label mb-1"><?php echo app('translator')->get('Date From'); ?></label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control form-control-sm">
                    </div>
                    <div>
                        <label class="form-label mb-1"><?php echo app('translator')->get('Date To'); ?></label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control form-control-sm">
                    </div>
                    <div class="align-self-end">
                        <button type="submit" class="btn btn--primary btn-sm"><i class="la la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                    </div>
                </form>

                <div class="d-flex flex-wrap gap-2 align-items-center">
                    <a href="<?php echo e(route('admin.sales.report.excel', request()->all())); ?>" class="btn btn-success btn-sm">
                        <i class="la la-file-excel"></i> <?php echo app('translator')->get('Export Excel'); ?>
                    </a>
                    <a href="<?php echo e(route('admin.sales.report.csv', request()->all())); ?>" class="btn btn-warning btn-sm text-white">
                        <i class="la la-file-alt"></i> <?php echo app('translator')->get('Export CSV'); ?>
                    </a>
                    <a href="<?php echo e(route('admin.sales.report')); ?>?<?php echo e(http_build_query(array_merge(request()->all(), ['print' => 'a4']))); ?>" target="_blank" class="btn btn-info btn-sm">
                        <i class="la la-print"></i> <?php echo app('translator')->get('Print A4'); ?>
                    </a>
                    <a href="<?php echo e(route('admin.sales.report')); ?>?<?php echo e(http_build_query(array_merge(request()->all(), ['print' => 'thermal']))); ?>" target="_blank" class="btn btn-dark btn-sm">
                        <i class="la la-receipt"></i> <?php echo app('translator')->get('Print 80mm'); ?>
                    </a>
                </div>
            </div>
            
            


            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table--light style--two table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Booking No.'); ?></th>
                                <th><?php echo app('translator')->get('Guest'); ?></th>
                                <th><?php echo app('translator')->get('Room Type'); ?></th>
                                <th><?php echo app('translator')->get('Room No'); ?></th>
                                <th><?php echo app('translator')->get('Check In'); ?></th>
                                <th><?php echo app('translator')->get('Check Out'); ?></th>
                                <th><?php echo app('translator')->get('Total'); ?></th>
                                <th><?php echo app('translator')->get('Paid'); ?></th>
                                <th><?php echo app('translator')->get('Due'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Date'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($b->booking_number); ?></td>
                                    <td><?php echo e($b->guest_name ?? 'N/A'); ?></td>
                                    <td><?php echo e($b->room_type ?? 'N/A'); ?></td>
                                    <td><?php echo e($b->room_no ?? 'N/A'); ?></td>
                                    <td><?php echo e(showDateTime($b->checkin_date)); ?></td>
                                    <td><?php echo e(showDateTime($b->checkout_date)); ?></td>
                                    <td><?php echo e(showAmount($b->total_amount)); ?></td>
                                    <td><?php echo e(showAmount($b->total_paid)); ?></td>
                                    <td><?php echo e(showAmount($b->due)); ?></td>
                                    <td>
                                        <span class="badge 
                                            <?php if($b->status == 'confirmed'): ?> badge--success
                                            <?php elseif($b->status == 'pending'): ?> badge--warning
                                            <?php else: ?> badge--danger
                                            <?php endif; ?>">
                                            <?php echo e(ucfirst($b->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e(showDateTime($b->created_at)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center text-muted"><?php echo app('translator')->get('No sales found for selected range'); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer text-end">
                <div class="fw-bold">
                    <span><?php echo app('translator')->get('Total Amount'); ?>:</span> <?php echo e(showAmount($totals['amount'])); ?> |
                    <span><?php echo app('translator')->get('Total Paid'); ?>:</span> <?php echo e(showAmount($totals['paid'])); ?> |
                    <span><?php echo app('translator')->get('Total Due'); ?>:</span> <?php echo e(showAmount($totals['due'])); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/admin/reports/sales_report.blade.php ENDPATH**/ ?>