<?php
$socialElement = getContent('social_icon.element', false, null, true);
$policyElement = getContent('policy_pages.element', false, null, true);
$footerContent = getContent('footer.content', true);
$contactContent = getContent('contact_us.content', true);
?>

<footer class="footer-section bg_img" style="background-image: url('<?php echo e(getImage('assets/images/frontend/footer/' . $footerContent->data_values->image, '1800x600')); ?>');">
    <div class="footer-section__top">
        <div class="position-relative z-index-2 container">

            <div class="row gy-5 justify-content-between">
                <div class="col-lg-4 col-sm-6">
                    <div class="footer-widget">
                        <a href="<?php echo e(route('home')); ?>" class="footer-logo">
                            <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_dark.png', '?' . time())); ?>" alt="image">
                        </a>
                        <p class="footer-about mt-3 text-white"><?php echo trans(@$footerContent->data_values->description) ?></p>
                        <?php if(count($socialElement) > 0): ?>
                            <ul class="social-links mt-4">
                                <?php $__currentLoopData = $socialElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e($social->data_values->url); ?>" target="_blank">
                                            <?php
                                                echo $social->data_values->social_icon;
                                            ?>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-2 col-sm-6">
                    <div class="footer-widget">
                        <h5 class="footer-widget__title"><?php echo app('translator')->get('Company'); ?></h5>
                        <ul class="footer-short-links">
                            <?php
                                $pages = App\Models\Page::where('tempname', $activeTemplate)
                                    ->where('is_default', 0)
                                    ->get();
                            ?>

                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <h5 class="footer-widget__title"><?php echo app('translator')->get('Useful Link'); ?></h5>
                        <ul class="footer-short-links">
                            <?php $__currentLoopData = $policyElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a
                                       href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"><?php
                                           echo $policy->data_values->title;
                                       ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <h5 class="footer-widget__title"><?php echo app('translator')->get('Contact Us'); ?></h5>
                        <ul class="footer-contact-info">
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <p><?php echo e(__($contactContent->data_values->address)); ?></p>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <p><a
                                       href="mailto:<?php echo e(__($contactContent->data_values->email_address)); ?>"><?php echo e(__($contactContent->data_values->email_address)); ?></a>
                                </p>
                            </li>
                            <li>
                                <i class="fas fa-phone-alt"></i>
                                <p><a
                                       href="tel:<?php echo e(__($contactContent->data_values->contact_number)); ?>"><?php echo e(__($contactContent->data_values->contact_number)); ?></a>
                                </p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-section__bottom">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <p class="text-white"><?php echo app('translator')->get('Copyright'); ?> &copy <?php echo e(date('Y')); ?>

                        <?php echo app('translator')->get('All Right Reserved'); ?>.</p>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php
$cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
?>
<?php if($cookie->data_values->status == 1 && !\Cookie::get('gdpr_cookie')): ?>
    <div id="cookiePolicy" class="cookies-card bg--default radius--10px hide text-center">
        <div class="cookies-card__icon">
            <i class="fas fa-cookie-bite"></i>
        </div>
        <p class="cookies-card__content mt-4">
            <?php
                echo @$cookie->data_values->short_desc;
            ?>
            <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank"><?php echo app('translator')->get('learn more'); ?></a>
        </p>
        <div class="cookies-card__btn mt-4">
            <button type="button" class="cookies-btn btn btn--base policy"><?php echo app('translator')->get('Allow'); ?></button>
        </div>
    </div>
<?php endif; ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/cookie.css')); ?>">
<?php $__env->stopPush(); ?>
<?php /**PATH /home/venddlyc/public_html/lawarooms.venddly.com/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>